<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstadoLiquidacionLiquidacion extends Model 
{

    protected $table = 'estado_liquidaciones_liquidaciones';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('liquidacion_id', 'estado_liquidacion_id');
    protected $visible = array('liquidacion_id', 'estado_liquidacion_id');

    public function estado_liquidacion()
    {
        return $this->belongsTo('EstadoLiquidacion', 'estado_liquidacion_id')->withTrashed();
    }

    public function liquidacion()
    {
        return $this->belongsTo('Liquidacion', 'liquidacion_id')->withTrashed();
    }

}